﻿var copyFieldMapping = {
    context: $(".v-copyFieldMappingFrom"),
    sourceId: 0,
    dtsType: 0,
    initialize: function () {
        var dataMap = $("#ImportationDataMapJson", copyFieldMapping.context).val();

        if (dataMap != "")
        {
            copyFieldMapping.fillMapping(dataMap);
        }
        else
        {
            var dtsType = $("#DtsType", copyFieldMapping.context).val();
            var sourceId = $("#SourceId", copyFieldMapping.context).val();

            if (!isNaN(dtsType))
                copyFieldMapping.dtsType = dtsType;

            if (!isNaN(sourceId))
                copyFieldMapping.sourceId = sourceId;

            $(".h-projects-autocomplete", copyFieldMapping.context).a4autocomplete({
                ajaxAction: a4.getProjectAction("GetProjectsForAutocomplete", "Importation"),
                ajaxParams: { dtsType: dtsType },
                valueProperty: "Id",
                labelProperty: "Name",
                categoryProperty: "FolderName",
                altValueField: $("#SourceId", copyFieldMapping.context),
                select: function (event, data) {
                    copyFieldMapping.sourceId = data && data.item ? data.item.Id : 0;
                    copyFieldMapping.validateTaskAutocomplete();

                    if (copyFieldMapping.sourceId != 0) {
                        $(".h-tasks-autocomplete", copyFieldMapping.context).val("");

                        $(".h-tasks-autocomplete", copyFieldMapping.context).a4autocomplete({
                            ajaxParams: { projectId: copyFieldMapping.sourceId, type: Enum.TaskTypesEnum.Import, dtsType: copyFieldMapping.dtsType }
                        });
                    }
                }
            });

            $(".h-tasks-autocomplete", copyFieldMapping.context).a4autocomplete({
                ajaxAction: a4.getAction("GetProjectTasksForAutocomplete", "Home", "Project"),
                ajaxParams: { projectId: copyFieldMapping.projectId, type: Enum.TaskTypesEnum.Import, dtsType: copyFieldMapping.dtsType },
                valueProperty: "Id",
                labelProperty: "Title",
                altValueField: $("#TaskId", copyFieldMapping.context)
            });

            copyFieldMapping.validateTaskAutocomplete();
        }   
    },
    validateTaskAutocomplete: function () {
        if (copyFieldMapping.sourceId == 0)
        {
            $(".h-tasks-autocomplete", copyFieldMapping.context).val("");
            $(".h-tasks-autocomplete", copyFieldMapping.context).a4autocomplete("disable");
        }
        else
        {
            $(".h-tasks-autocomplete", copyFieldMapping.context).a4autocomplete("enable");
        }
    },
    fillMapping: function (dataMap) {
        var importWizard = a4.parent().importWizard;

        if (typeof importWizard !== "undefined")
        {
            var fullCopy = $("#FullCopy", copyFieldMapping.context).val().toLowerCase();
            $(".v-copyMappingFromWarning", importWizard.context).toggleClass("hidden", (fullCopy == "true"));

            importWizard.recalculateMappings(JSON.parse(dataMap));
            modalDialog.close();
        }
    }
};

$(document).ready(function () {
    if (copyFieldMapping.context.length > 0) {
        copyFieldMapping.initialize();
    }
});
